VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form frmDigital 
   Caption         =   "Digital Input and Output on Same Board"
   ClientHeight    =   8265
   ClientLeft      =   1890
   ClientTop       =   1605
   ClientWidth     =   6945
   Icon            =   "EasyDigital.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8265
   ScaleWidth      =   6945
   Begin VB.Frame frmChan 
      Caption         =   "Channel Select"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   840
      TabIndex        =   16
      Top             =   2160
      Width           =   5175
      Begin VB.CommandButton cmdConfigChans 
         Caption         =   "Configure Channels"
         Height          =   495
         Left            =   480
         TabIndex        =   21
         Top             =   360
         Width           =   1695
      End
      Begin VB.ComboBox DOchan 
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Left            =   4080
         TabIndex        =   20
         Text            =   "0"
         Top             =   600
         Width           =   735
      End
      Begin VB.ComboBox DIchan 
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Left            =   4080
         TabIndex        =   18
         Text            =   "1"
         Top             =   240
         Width           =   735
      End
      Begin VB.Label Label4 
         Caption         =   "Output Channel"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   135
         Left            =   2760
         TabIndex        =   19
         Top             =   600
         Width           =   1335
      End
      Begin VB.Label Label3 
         Caption         =   "Input Channel"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2760
         TabIndex        =   17
         Top             =   240
         Width           =   1095
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Open Driver and Initialize Hardware"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   840
      TabIndex        =   12
      Top             =   720
      Width           =   5175
      Begin VB.CommandButton cmdOpen 
         Caption         =   "Open Driver"
         Height          =   495
         Left            =   480
         TabIndex        =   15
         Top             =   480
         Width           =   1815
      End
      Begin VB.ComboBox devNum 
         Height          =   315
         Left            =   4080
         TabIndex        =   14
         Text            =   "0"
         Top             =   480
         Width           =   735
      End
      Begin VB.Label Label2 
         Caption         =   "Device Number"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2640
         TabIndex        =   13
         Top             =   600
         Width           =   1215
      End
   End
   Begin VB.Frame frmDO 
      Caption         =   "Digital Output"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   840
      TabIndex        =   6
      Top             =   4800
      Width           =   5175
      Begin VB.CheckBox chkBit1 
         Caption         =   "Bit1"
         Height          =   375
         Left            =   2400
         TabIndex        =   11
         Top             =   720
         Width           =   615
      End
      Begin VB.CheckBox chkBit2 
         Caption         =   "Bit2"
         Height          =   375
         Left            =   3240
         TabIndex        =   10
         Top             =   360
         Width           =   615
      End
      Begin VB.CheckBox chkBit3 
         Caption         =   "Bit3"
         Height          =   375
         Left            =   3240
         TabIndex        =   9
         Top             =   720
         Width           =   615
      End
      Begin VB.CheckBox chkBit0 
         Caption         =   "Bit0"
         Height          =   375
         Left            =   2400
         TabIndex        =   8
         Top             =   360
         Width           =   735
      End
      Begin VB.CommandButton cmdDO 
         Caption         =   "Set Polled DO Value"
         Height          =   495
         Left            =   240
         TabIndex        =   7
         Top             =   480
         Width           =   1815
      End
   End
   Begin VB.Frame frmDI 
      Caption         =   "Digital Input"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   840
      TabIndex        =   3
      Top             =   3360
      Width           =   5175
      Begin VB.CommandButton cmdDI 
         Caption         =   "Read Polled DI Input"
         Height          =   495
         Left            =   360
         TabIndex        =   5
         Top             =   480
         Width           =   1815
      End
      Begin VB.Label lblDI 
         BackColor       =   &H8000000E&
         Height          =   255
         Left            =   2400
         TabIndex        =   4
         Top             =   600
         Width           =   615
      End
   End
   Begin DlsrLib.DriverLINXSR SR_DO 
      Left            =   5640
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   5520
      TabIndex        =   1
      Top             =   7200
      Width           =   735
   End
   Begin DlsrLib.DriverLINXSR SR_DI 
      Left            =   4920
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      BorderStyle     =   1  'Fixed Single
      Enabled         =   0   'False
      Height          =   255
      Left            =   840
      TabIndex        =   0
      Top             =   6360
      Width           =   5175
   End
End
Attribute VB_Name = "frmDigital"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'program was tested with KPCI-PIO24 using KPCIPIO-850A04 driver revision in Win98SE, VB6
'
' this example program dynamically configures a digital channel for output
' and then makes use of two SR controls to write values to the output channel and
' read values from another channel
'
'
Dim INchan As Integer
Dim OUTchan As Integer


Private Sub cmdDI_Click()
    SR_DI.Refresh
    If SR_DI.Res_result <> 0 Then
        lblStatus.Caption = SR_DI.Message
    Else
        lblDI.Caption = Str(SR_DI.Res_Sta_ioValue) ' polled mode result
        ' the SR control can store single value result in .Res_Sta_ioValue property
        
        ' display message...hopefully 'no error' if all is well
        lblStatus.Caption = SR_DI.Message + " reading Digital Input Channel " + Str(INchan)
    End If
End Sub

Private Sub cmdDO_Click()
Dim doVal As Integer
doVal = chkBit0.Value + 2 * chkBit1.Value + 4 * chkBit2.Value + 8 * chkBit3.Value
SR_DO.Res_Sta_ioValue = doVal
SR_DO.Refresh
lblStatus.Caption = SR_DO.Message + " on Digital Output Channel " + Str(OUTchan)
End Sub

Private Sub cmdExit_Click()
SR_DI.Req_DLL_name = ""  ' unload the driver for each SR
SR_DO.Req_DLL_name = ""
End
End Sub

Private Sub cmdOpen_Click()
Dim devNumber As Integer
Dim DrvName As String

'Open drivers for each SR object

' change driver name as required for specific boards in use

DrvName = "kpcipio"  ' for the KPCI-PIO24 or KPCI-PIO96 boards
' use "kmbpio" for ISA bus PIO products
' use "kpci3160" for KPCI-3160
' use "kpci3100" for KPCI-3101, KPCI-3102/3/4 or KPCI-3116/10 boards
' set both controls equal to this driver name
SR_DI.Req_DLL_name = DrvName
SR_DO.Req_DLL_name = SR_DI.Req_DLL_name 'load same DLL name for both controls
                                       
' read in the device number from the form's drop down
devNumber = CInt(devNum.Text)

'Initialize each SR
SR_DI.Req_device = devNumber    ' should agree wtih setting in
SR_DI.Req_mode = DL_OTHER       ' your DLinx Config Panel
SR_DI.Req_op = DL_INITIALIZE
SR_DI.Refresh

'Check for error
lblStatus.Caption = SR_DI.Message


SR_DO.Req_device = devNumber
SR_DO.Req_mode = DL_OTHER
SR_DO.Req_op = DL_INITIALIZE
SR_DO.Refresh

'Check for error
 lblStatus.Caption = SR_DO.Message
 
 ' set focus back to our form
 frmDigital.SetFocus
 
 ' allow channel selection and configuration
 If SR_DI.Message = "No error" Then
 frmChan.Enabled = True
 Else
 Beep  ' give an error beep
 End If

End Sub

Private Sub cmdConfigChans_Click()
 
 ' get the channel assignments from the form
 INchan = CInt(DIchan.Text)
 OUTchan = CInt(DOchan.Text)
 
' config a channel for output
ConfigDigitalChannelForOutput SR_DO, OUTchan
' set up DO task for this configured channel
SetupPolledDigitalOutputTask SR_DO, OUTchan
'set up DI task
If INchan <> OUTchan Then  ' if in and out are same channels don't override the output configuration
ConfigDigitalChannelForInput SR_DI, INchan
End If
SetupPolledDigitalInputTask SR_DI, INchan

frmDI.Enabled = True
frmDO.Enabled = True
End Sub


Private Sub Form_Load()
Dim i As Integer
' populate the drop down with legal device numbers
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it to select device 0 by default
devNum.ListIndex = 0
'
' populate the channel list boxes too
For i = 0 To 2
DIchan.AddItem Str(i), i
Next i
DIchan.ListIndex = 1  ' set the channel selector equal to one of the channels
' the KPCI-PIO24 has only three channels.....for KPCI-PIO96 or KPCI-3160, expand this on out
' to 11 for the 12 legal channels of that board
'
' use the LDD object of DriverLINX to determine how many channels exist to make
' this program more dynamic....

For i = 0 To 2
DOchan.AddItem Str(i), i
Next i
DOchan.ListIndex = 0  ' set the channel selector equal to one of the channels
End Sub

Public Sub ConfigDigitalChannelForOutput(SR As Control, chan As Integer)
' ports on *most* digital I/O boards initialize as inputs
' to use a channel for output, that channel must first be
' configured for output else an invalid channel error will result

 
' code below will Configure a Channel for Output
SR.Req_subsystem = DL_DO  ' the subsystem to assign the channel to
SR.Req_mode = DL_OTHER
SR.Req_op = DL_CONFIGURE  ' it is a configuration type operation
SR.Evt_Tim_type = DL_DIOSETUP
SR.Evt_Tim_dioChannel = chan   ' which channel to configure as Output
SR.Evt_Tim_dioMode = DL_DIO_BASIC
SR.Evt_Str_type = DL_NULLEVENT
SR.Evt_Stp_type = DL_NULLEVENT
SR.Sel_chan_N = 0
SR.Refresh                      ' carry out the request
lblStatus.Caption = SR.Message & " configuring for output."  'display result message
End Sub
Public Sub ConfigDigitalChannelForInput(SR As Control, chan As Integer)
'
'NOTE:  only need to configure for input if the channel had previously
' been configured for output. By default, configurable channels are inputs
' at power up.
'
' code below will Configure a Channel for Input
SR.Req_subsystem = DL_DI  ' the subsystem to assign the channel to
SR.Req_mode = DL_OTHER
SR.Req_op = DL_CONFIGURE  ' it is a configuration type operation
SR.Evt_Tim_type = DL_DIOSETUP
SR.Evt_Tim_dioChannel = chan   ' which channel to configure as Input
SR.Evt_Tim_dioMode = DL_DIO_BASIC
SR.Evt_Str_type = DL_NULLEVENT
SR.Evt_Stp_type = DL_NULLEVENT
SR.Sel_chan_N = 0
SR.Refresh                      ' carry out the request
lblStatus.Caption = SR.Message & " configuring for input."  'display result message
End Sub

Public Sub SetupPolledDigitalInputTask(SR As Control, chan As Integer)
        
'Setup Service Request for polled mode Input operation
SR.Req_subsystem = DL_DI
SR.Req_mode = DL_POLLED
SR.Req_op = DL_START
SR.Evt_Str_type = DL_NULLEVENT
SR.Evt_Stp_type = DL_NULLEVENT
SR.Evt_Tim_type = DL_NULLEVENT
SR.Sel_chan_format = DL_tNATIVE
SR.Sel_chan_N = 1    ' one channel only
SR.Sel_chan_start = chan
SR.Sel_chan_startGainCode = 0
SR.Sel_buf_samples = 1
SR.Sel_buf_N = 0

End Sub
Public Sub SetupPolledDigitalOutputTask(SR As Control, chan As Integer)
' setup DO Service Request for polled mode Output operation
SR.Req_subsystem = DL_DO
SR.Req_mode = DL_POLLED
SR.Req_op = DL_START
SR.Evt_Str_type = DL_NULLEVENT
SR.Evt_Stp_type = DL_NULLEVENT
SR.Evt_Tim_type = DL_NULLEVENT
SR.Sel_chan_format = DL_tNATIVE
SR.Sel_chan_N = 1
SR.Sel_chan_start = chan   'this channel should be configured for Output already
SR.Sel_chan_startGainCode = 0
SR.Sel_buf_samples = 1
SR.Sel_buf_N = 0
End Sub
